<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnsToExamAttemptsTable extends Migration
{
    public function up()
    {
        Schema::table('exam_attempts', function (Blueprint $table) {
            $table->enum('Type', ['quiz', 'practice_test', 'mock_interview'])->default('quiz')->after('Attempted_at');
            $table->unsignedBigInteger('Interview_id')->nullable()->after('Type');
            $table->foreign('Interview_id')->references('Interview_id')->on('interview_attempts')->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::table('exam_attempts', function (Blueprint $table) {
            $table->dropForeign(['Interview_id']);
            $table->dropColumn('Interview_id');
            $table->dropColumn('Type');
        });
    }
}
